/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// AngularDimension conv function

#include <stdafx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT TestDrawingAngularCF() 
{
	START_METHOD("AngularDimension")
	
	HRESULT status = CONV_SUCCESS ;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IDrawingDocument *activeDraw = NULL;

	status = GetActiveDrawingDoc(&activeDraw, &activeGraphicDoc);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign= NULL;
	
	AfxMessageBox("Select a View in the Drawing");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *localObjectSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Graphic"), &localObjectSet);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(localObjectSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pGraph1 = NULL;
	status = pObjectIt->start(&pGraph1);
	CHECK_RETURN_STATUS(status)

	IView *pView1 = CAST(IView, pGraph1);

	status = pView1->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox ("Select two line angular items in the active View");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)
	
	localObjectSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Graphic"), &localObjectSet);
	CHECK_RETURN_STATUS(status)

	pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(localObjectSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	pGraph1 = NULL;
	status = pObjectIt->start(&pGraph1);
	CHECK_RETURN_STATUS(status)

	IDispatch *pGraph2 = NULL;
	status = pObjectIt->Next(&pGraph2);
	CHECK_RETURN_STATUS(status)

	IAngularDimLine *angulardim = NULL;
	status = AngularDimension(pDesign, activeDraw, CAST(IGraphic, pGraph1), CAST(IGraphic, pGraph2), &angulardim);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("AngularDimension");
	CHECK_RETURN_STATUS(status)

	END_METHOD("AngularDimension")

}
